# This program uses a For loop to simulate a simple poptulation
# growth given the starting population, average daily increase,
# and number of days. Note that the program expects the average
# daily increase as a percentage (e.g. 15, NOT .15). Also note
# that the average daily increase CAN be a negative number,
# indicating a decline in population over time.

def main():
    # We'll need a variable for the starting population.
    # We'll grab the user input, convert it to an integer,
    # and then take the absolute value to avoid negatives.
    organisms = abs(int(input("Starting number of organisms: ")))
    # Similarly, we'll need a variable for the average daily
    # increase, but we'll leave off the absolute value since
    # this could be a negative number, indicating a devline
    # in population over time.
    daily = int(input("Average daily increase (percent): "))
    # We'll need one more variable for the number of days to
    # simulate. We'll take the absolute value here to avoid
    # negatives.
    days = abs(int(input("Number of days to multiply: ")))
    # We'll convert the average daily increase from a percentage
    # to a decimal number to make the math easier.
    percent = (100 + daily) / 100
    # Now let's set up a quick and dirty, two column layout
    # for our output.
    print("Day Approximate      Population")
    # The For loop needs a variable for its index and
    # and takes arguments for the range. We'll use number of
    # days as the range for our loop.
    for day in range(days):
        # Since our loops index starts at 0, we'll add 1 to each
        # day to make the printout a little easier to read. Again,
        # this is just a quick and dirty, two column layout.
        print(day + 1, "                  ", organisms)
        # After printing out the population for the current day,
        # we'll do a little math to calculate population for the
        # next day. Because of how this loop runs, the population
        # will be calculated for one additional day that is never
        # shown. How could we modify this program to show that
        # final population?
        organisms = organisms * percent

if __name__=='__main__':
    main()